#include "typesIIgs.r"

/* Shell Application Resources - v3.0 Deatherage, Strnad, Luther
   Copyright 1988-1990 Apple Computer, Inc.
   All shell resources are in the range 0x0000nnnn, the lowest allowable 64K
   range of application resource IDs. */

/* for clarity and ease of distinguishing between IDs of resources and IDs of
   toolbox entities, identifiers for resource IDs are suffixed with RID and
   identifiers for other toolbox entities such as menu and window controls are
   suffixed with ID */
	   
#define BaseResID 0x0			/* starting offset for shell resources */
#define MenuBarIDShift 0x1000	/* multiplier for menu numbers in */
								/* resource IDs */
#define MenuIDShift 0x100		/* multiplier for menu bar numbers in */
								/* resource IDs */

/* The menu resource IDs are in the form 0x0000wxyy calculated as
   ID = BaseResID + (w*MenuBarIDShift) + (x*MenuIDShift) + yy, where w is the
   menu bar number in the range $1 to $F, x is the number of the menu in the
   range $0 to $F and yy is the number of the item number in that menu in the
   range $01 to $FF. The shell program uses the conventions that:
   
   1. the resource id of a menu is that of the zeroth item within it,
   
   2. the resource id of a menu bar is that of the zeroth item in the zeroth
      menu contained within that menu bar, and
   
   3. values of zero for w and x correspond to the 16th menubar or menu in a
      menu bar.
   
   For example, the 2nd item from the 3rd menu in the 5th menu bar has resource
   ID 0x00005302 when BaseResID is 0x0, MenuIDShift is 0x100, and
   MenuBarIDShift is 0x1000. The resource id of the menu containing this item
   is that of the zeroth item in the 3rd menu of the 5th menu bar, 0x00005300.
   The resource id of the menu bar containing this menu and menu item is that
   of the zeroth item in the zeroth menu, 0x00005000.
   
   An exception to the menu resource id being of the form 0x0000wxyy is any
   menu possibly containing more than 256 items. Font menus built using the
   Font Manager FixFontMenu call are an example of this. Menus built using
   FixFontMenu will contain more than 256 items if the user has installed more
   than 256 fonts in the fonts folder. To anticipate this case, and to preserve
   the correspondence inherent in these conventions between resource ids and
   control or menu item ids, the resource id would be formulated differently.
   One approach would be to to have the resource id of this menu be of the form
   0x0000wnnn where w would be any number $0 to $F, not assigned to a menu bar
   (also not assigned to pop-up menu per discussion below). Another approach,
   that still uses the conventions being described, would be to have the 
   resource id of this menu be of the form 0x0000wxyy where x would be the 
   lowest number $0 to $F not used by another menu in that menu bar.

   Further conventions used by the shell program are:
   
   4. control and item IDs and resource IDs for controls and items are the same
      and resource IDs for their title strings are also the same, and 
		  
   5. since the title string resource IDs are the same as the menu resource
      IDs, resource IDs for other resources of type rPString are assumed to be
	  of the form 0x0000wnnn where w is any number $0 to $F not assigned to a
	  menu bar; as a suggestion, this value w can be distinct for each kind of
	  window using resources within the program, if the number of menu bars
	  plus the number of distinct kinds of resource-using windows is 16 or
	  less.
	  
   Note that structuring the menu resource IDs in this form 0x0000wxyy avoids a
   bug in the system version 5.0 of NewMenuBar2 where it cannot release
   resources unless the high word of the resource ID is zero. These conventions
   also allow for easy processing of resource IDs entirely represented in the
   low word of the ID, for easy editing of menus, menu bars, and menu items, as
   shown below, and for a reference when debugging. These conventions are
   suggested for programming convenience only, programmers may wish to devise
   other conventions for assigning resource IDs differently.
   
   For instance:
   
   1. programmers may want to utilize the high word of resource IDs,
   
   2. programmers may want to consolidate the RID, title RID, and ID
      identifiers in their programs if these will always be defined to be the
	  same.
   
   3. pop-up menus could be assigned using a form similar to that used above
      for menus except that w would be any number $0 to $F, not assigned to a
	  menu bar, designating a window in which the pop-up was used.
   
   4. resource IDs for the other various resource types, in general, may be
      assigned so that the low word of the resource ID is of approximate form
	  0x0000abcc where a is any number $0 to $F, not assigned to a menu bar,
	  designating a window in which the resource is used, b is any nine bit
	  wide zero value, and cc is a number $0 to $7F distinguishing the resource
	  from others of the same type used in a particular window. For programs
	  not using suggestion (2) above and having windows using a large number of
	  resources, the value for b could be a nine bit value designating the
	  resource type with the high order bit in the least significant position.
   
   Again, these are only illustrations of how programmers may adopt resource ID
   conventions suitable within a particular program.
   
   CAUTION: Resource IDs must be distinct within each resource type and must
   not be > 0x07FEFFFF.   
	   */
	   
#define AboutAlertStringRID BaseResID + 1
#define MenuAlertStringRID BaseResID + 2

#define MenuBarOneRID BaseResID + (1 * MenuBarIDShift)

#define AppleMenuRID MenuBarOneRID + (1 * MenuIDShift)
#define FileMenuRID MenuBarOneRID + (2 * MenuIDShift)
#define EditMenuRID MenuBarOneRID + (3 * MenuIDShift)

#define AboutRID AppleMenuRID + 1

#define QuitRID FileMenuRID + 2

/* The edit menu item IDs are by convention defined with the values below,
   starting at 250. Since this program uses the same values for the
   corresponding resource IDs, be careful not to attempt to reuse these
   resource IDs items and title strings in particular */
   
#define UndoRID 250
#define CutRID 251
#define CopyRID 252
#define PasteRID 253
#define ClearRID 254
#define CloseRID 255

#define AppleMenuTitleRID MenuBarOneRID + (1 * MenuIDShift)
#define FileMenuTitleRID MenuBarOneRID + (2 * MenuIDShift)
#define EditMenuTitleRID MenuBarOneRID + (3 * MenuIDShift)

#define AboutTitleRID AppleMenuRID + 1

#define QuitTitleRID FileMenuRID + 2

#define UndoTitleRID 250
#define CutTitleRID 251
#define CopyTitleRID 252
#define PasteTitleRID 253
#define ClearTitleRID 254
#define CloseTitleRID 255

#define MenuBarOneID BaseResID + (1 * MenuBarIDShift)

#define AppleMenuID MenuBarOneID + (1 * MenuIDShift)
#define FileMenuID MenuBarOneID + (2 * MenuIDShift)
#define EditMenuID MenuBarOneID + (3 * MenuIDShift)

#define AboutID AppleMenuID + 1

#define QuitID FileMenuID + 2

#define UndoID 250
#define CutID 251
#define CopyID 252
#define PasteID 253
#define ClearID 254
#define CloseID 255

#define MainToolStartupRID BaseResID+1

resource rAlertString (AboutAlertStringRID)	{
	"7"
	"3/"
	TBCenterJust
	"Apple IIGS Shell Application, Version 3.0"
	TBEndOfLine
	"By Apple II Developer Technical Support"
	TBEndOfLine
	"Copyright 1988-1990 Apple Computer, Inc."
	TBEndOfLine
	"/^#0\000"
};

resource rAlertString (MenuAlertStringRID)	{
	"2"
	"0/"
	TBCenterJust
	"This menu item is under construction."
	TBEndOfLine
	"Please add some code."
	TBEndOfLine
	"/^#0\000"
};

resource rMenuBar (MenuBarOneRID)	{
	
/* Note: The form of this resource ID $0000wxyy where w is the menu bar number
		 avoids a bug in NewMenuBar2 - it can't release resources unless the
		 high word of the ID is zero.  --MD	*/
	   	   
/* 1.1B1 - Changed the Apple Menu to properly use Color Replace highlighting,
   to avoid the "Green Apple" when the menu is pulled down.  --MD */
	
	{
	AppleMenuRID,										/* Apple menu */
	FileMenuRID,										/* File menu */
	EditMenuRID											/* Edit menu */
	}
};

resource rMenu (AppleMenuRID)	{
	AppleMenuID,										/* Menu ID */
	RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,
														/* flags */
	AppleMenuTitleRID,									/* Title reference */
	{AboutID}										/* Menu item reference */
};

resource rMenu (FileMenuRID)	{
	FileMenuID,											/* Menu ID */
	RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,
														/* flags */
	FileMenuTitleRID,									/* Title reference */
	{CloseID,
	QuitID}											/* Menu item references */
};

resource rMenu (EditMenuRID)	{
	EditMenuID,											/* Menu ID */
	RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache+
		rmDisabled,
														/* flags */
	EditMenuTitleRID,									/* Title reference */
	{UndoID,
	CutID,
	CopyID,
	PasteID,
	ClearID} 										/* Menu item references */
};

resource rMenuItem (AboutRID,nocrossbank)	{
	AboutID,											/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift+rMIDivider,			/* Item flags */
	AboutTitleRID										/* Title reference */
};

resource rMenuItem (CloseRID,nocrossbank)	{
	CloseID,											/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift+rMIDivider+rMIDisabled,
														/* Item flags */
	CloseTitleRID										/* Title reference */
};

resource rMenuItem (QuitRID,nocrossbank)	{
	QuitID,												/* Item ID */
	"Q","q",											/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	QuitTitleRID										/* Title reference */
};

resource rMenuItem (UndoRID,nocrossbank)	{
	UndoID,												/* Item ID */
	"Z","z",											/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift+rMIDivider+rMIDisabled,
														/* Item flags */
	UndoTitleRID										/* Title reference */
};

resource rMenuItem (CutRID,nocrossbank)	{
	CutID,												/* Item ID */
	"X","x",											/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift+rMIDisabled,		/* Item flags */
	CutTitleRID										/* Title reference */
};

resource rMenuItem (CopyRID,nocrossbank)	{
	CopyID,												/* Item ID */
	"C","c",											/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift+rMIDisabled,		/* Item flags */
	CopyTitleRID										/* Title reference */
};

resource rMenuItem (PasteRID,nocrossbank)	{
	PasteID,											/* Item ID */
	"V","v",											/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift+rMIDisabled,		/* Item flags */
	PasteTitleRID										/* Title reference */
};

resource rMenuItem (ClearRID,nocrossbank)	{
	ClearID,											/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift+rMIDisabled,		/* Item flags */
	ClearTitleRID										/* Title reference */
};


/* The following PStrings are our menu titles and IDs.  1.1B1 changes the menu
   titles to use two spaces on either side, as recommended for 640 mode in
   IIgs TN #5.  --MD */
   
resource rPString (AppleMenuTitleRID,nocrossbank)	{
	"@"
};

resource rPString (AboutTitleRID,nocrossbank)	{
	"About the Shell..."
};

resource rPString (FileMenuTitleRID,nocrossbank)	{
	"  File  "
};

resource rPString (CloseTitleRID,nocrossbank)	{
	"Close"
};

resource rPString (QuitTitleRID,nocrossbank)	{
	"Quit"
};

resource rPString (EditMenuTitleRID,nocrossbank)	{
	"  Edit  "
};

resource rPString (UndoTitleRID,nocrossbank)	{
	"Undo"
};

resource rPString (CutTitleRID,nocrossbank)	{
	"Cut"
};

resource rPString (CopyTitleRID,nocrossbank)	{
	"Copy"
};

resource rPString (PasteTitleRID,nocrossbank)	{
	"Paste"
};

resource rPString (ClearTitleRID,nocrossbank)	{
	"Clear"
};

resource rToolStartup (MainToolStartupRID,nocrossbank)	{
	
/* We've expanded this list over the original 1.0 Shell list to include more
   tools for desk accessories to use, as described in Apple IIgs Technical
   Note #53, "Desk Accessories and Tools."  The table is also longer because
   the previous version of the shell didn't load ROM-based tools it started
   (like QuickDraw).
   
   As a suggestion, maintain a complete list of the tools as shown below. This
   way it is easy to edit tools in and out of the list by inserting or deleting
   the comment symbols, and it is clear which tools are loaded and which tools
   are not loaded.
   
   The Resource Manager (#30) is automatically taken care of by StartUpTools
   (or else it couldn't read this resource!) The Tool Locator and Memory
   Manager are started up seperately, prior to StartUpTools and shut down after
   ShutDownTools. */
   
	$4080,										/* 640 mode + fastport aware */
	{
		3,$0300,	/* misc tools */
		4,$0301,	/* quickdraw */
		5,$0302,	/* desk manager */
		6,$0300,	/* eventMgr */
		7,$0200,	/* scheduler */
/*		8,$0301,	/* sound tools */
/*		9,$0201,	/* ADB tools */
/*		10,$0202,	/* SANE */
		11,$0200,	/* int math */
/*		12,$0201,	/* Text Tool Set */
		14,$0301,	/* Window Manager */
		15,$0301,	/* Menu Manager */
		16,$0301,	/* Control Manager */
/*		17,$0300,	/* System Loader */
		18,$0301,	/* QD Aux */
		19,$0300,	/* print manager */
		20,$0301,	/* LineEdit tool set */
		21,$0302,	/* Dialog Manager */
		22,$0300,	/* Scrap manager */
		23,$0301,	/* standard file */
/*		25,$0104,	/* NoteSynth */
/*		26,$0104,	/* Note Seq */
		27,$0301,	/* Font manager */
		28,$0301,	/* list manager */
/*		29,$0101,	/* ACE */
/*		32,$0103,	/* Midi Tools */
/*		34,$0101	/* text edit */
	}
};

/*  Application-specific resources  */
